#include <Core/Core.h>

using namespace Upp;

String DecodeEncodedString(String& s)
{
	String decodedstring;
	
	for(int begin = 0, end = 0, pos = 0; pos <= s.GetCharCount(); pos++) {
		pos = s.Find("=?", begin);
		if(pos < begin || pos > begin) {
			if(pos == -1) {
				if(begin >= 0)
					pos  = s.GetCharCount();
				else
					break;
			}
			end = pos;
			for(int c = begin; c < end; c++) {
				if(!IsSpace(s[c])) {
					decodedstring << s.Mid(begin, end - begin);
					break;
				}
			}
			begin = end;
		}
		else
		if(begin == pos) {
			String decodebuffer;
			 begin = pos += 2;
			 for(int n = 0; pos <= s.GetCharCount(); pos++) {
			     // Quoted-Printable Word Format:
			     // (Character set) ? (Encoding) ? (Word)
			     if(n < 2) {
			         if(s[pos] == '?') {
			             decodebuffer.Cat(" ", 1);
			             n++;
			         }
			         else
			             decodebuffer.Cat(s[pos], 1);
			     }
			     else {
			         // Find ending token.
			         if((end = s.Find("?=", pos)) == -1) 
			             return decodedstring = t_("<Parser Error: Cannot Find ending token.>");
			         else {
							// Check for spaces within the qp word. Some older mail clients do 
							// not encode ' ' spaces to '_'. This behaviour is against the rules.
							// We have to fix their fault.
							for(pos; pos < end; pos++) {
								if(IsSpace(s[pos]))
									decodebuffer.Cat("_");
								else
									decodebuffer.Cat(s[pos], 1);
							}
							pos = end += 2;
							begin = pos;
							Buffer<char> chs(32), enc(2), txt;
							txt.Alloc(decodebuffer.GetLength());
							sscanf(decodebuffer, "%s %s %s",
						       &chs[0],
						       &enc[0],
						       &txt[0]);
							int charset = CharsetByName(chs);
							// Now we are ready to decode the quoted-printable text.
							// QP text should be either base64 or "Q" encoded.
							if(String(enc) == "B") {
								decodedstring << ToUnicode(Base64Decode(String(txt)), charset);
								break;
							}
							else if(String(enc) == "Q") {
								String qtext(txt);
								for(int i = 0; i < qtext.GetCharCount(); i++) {
									if(qtext[i] == '=') {
										String ascii;
										unsigned int chr1 = ctoi(qtext[++i]);
										unsigned int chr2 = ctoi(qtext[++i]); 
										ascii.Cat(16 * chr1 + chr2);
										decodedstring << ToUnicode(ascii, charset);																		
									}
									else
									if(qtext[i] == '_') {
										decodedstring.Cat(" ");
									}
									else
										decodedstring.Cat(qtext[i], 1);		
								}
									
							}
						break;								
			        }
			    }			     
			}
		}
	}
	
	return decodedstring;
}

String FindHeadersElement(String& s, String e)
{
	String output, element;
	int pos = s.Find("\n" + e);
	if(pos >= 0) {
		element = s.Mid(++pos + e.GetLength() + 1);
		for(int j = 0; j < element.GetCharCount(); j++) {
			if(element[j] == '\r' &&
			   element[j + 1] == '\n') {
			    if(element[j + 2] == '\t' ||
			    	element[j + 2] == ' ')
					continue;
				else
				{
					output = element.Mid(0, j);
					break;
				}
			}
		}
	}
	return DecodeEncodedString(output);
}